package expertSystemShell;



import unificationSolver.AndSolutionNode;
import unificationSolver.SubstitutionSet;
import unificationSolver.RuleSet;

public class ESAndSolutionNode extends AndSolutionNode implements ESSolutionNode  {
	
	private double certainty = 0.0;
	
	public ESAndSolutionNode(ESAnd goal, RuleSet rules,
			SubstitutionSet parentSolution) throws CloneNotSupportedException {
		super(goal, rules, parentSolution);
		nodesCreated++;
	}


	public synchronized SubstitutionSet nextSolution()  throws CloneNotSupportedException 
	{
		SubstitutionSet solution = super.nextSolution();
		if(solution == null)
		{
			certainty = 0.0;
			return null;
		}
		
		ESSolutionNode head = (ESSolutionNode) getHeadSolutionNode();
		ESSolutionNode tail = (ESSolutionNode) getTailSolutionNode();
		
		if(tail == null)
			certainty = head.getCertainty();
		else
			certainty = Math.min(head.getCertainty(), tail.getCertainty());
			
		return solution;
	}
	
	public double getCertainty(){
		return certainty;
	}
}
 